<?php
// src/config/auth.php

// Définir le chemin de base une fois pour toutes
define('ROOT_PATH', dirname(__DIR__)); // → /home/.../src

require_once ROOT_PATH . '/models/User.php';
require_once ROOT_PATH . '/config/db.php';


session_start();

// src/config/auth.php

class Auth {
    private $userModel;

    public function __construct() {
    $db = new Database();
    $this->userModel = new User($db->getConnection());

    // Assurez-vous que le rôle est bien chargé
    if ($this->isLoggedIn()) {
        $user = $this->userModel->findById($_SESSION['user_id']);
        if ($user) {
            $_SESSION['role'] = $user['role']; // ✅ Réactualise le rôle au besoin
        }
    }
}




// src/config/auth.php




    // ✅ Ajoutez cette méthode pour permettre l'inscription
    public function registerUser($nom, $email, $password, $role = 'tresorier') {
        return $this->userModel->register($nom, $email, $password, $role);
    }


    // Vérifie si l'utilisateur est connecté
    public function isLoggedIn() {
        return isset($_SESSION['user_id']);
    }

    // Vérifie le rôle
 public function hasRole($roles) {
    if (!$this->isLoggedIn()) {
        return false;
    }

    $allowed = is_array($roles) ? $roles : [$roles];
    $currentRole = $_SESSION['role'] ?? null;

    return in_array($currentRole, $allowed);
}



    // Renvoie l'utilisateur actuel
    public function user() {
        return $this->isLoggedIn() ? $this->userModel->findById($_SESSION['user_id']) : null;
    }

    // Connexion
    public function login($email, $password) {
        $user = $this->userModel->login($email, $password);
        if ($user) {
            $_SESSION['user_id'] = $user['id'];
            $_SESSION['role'] = $user['role'];
            return true;
        }
        return false;
    }

    // Déconnexion
    public function logout() {
        session_destroy();
    }
}
?>