const CACHE_NAME = 'goshen-tabernacle-v1';
const urlsToCache = [
  '/public/index.php',
  '/public/encaissement.php',
  '/public/dons-parcelle.php',
  '/public/depenses.php',
  '/public/patrimoine.php',
  '/public/maintenance.php',
  '/public/rapports.php',
  '/assets/css/style.css',
  '/assets/js/app.js',
  '/assets/img/logo.png',
  '/manifest.json'
];

self.addEventListener('install', (event) => {
  event.waitUntil(
    caches.open(CACHE_NAME)
      .then((cache) => cache.addAll(urlsToCache))
  );
});

self.addEventListener('fetch', (event) => {
  event.respondWith(
    caches.match(event.request)
      .then((response) => {
        return response || fetch(event.request);
      })
  );
});