<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

require_once '../src/config/auth.php';
$auth = new Auth();

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $nom = trim($_POST['nom']);
    $email = trim($_POST['email']);
    $password = $_POST['password'];
    $confirm = $_POST['confirm'];

    if (empty($nom) || empty($email) || empty($password)) {
        $error = "Tous les champs sont obligatoires.";
    } elseif ($password !== $confirm) {
        $error = "Les mots de passe ne correspondent pas.";
    } elseif (strlen($password) < 6) {
        $error = "Le mot de passe doit faire au moins 6 caractères.";
    } else {
        try {
            // ✅ Appel de la méthode publique
            $result = $auth->registerUser($nom, $email, $password, 'admin');
            if ($result) {
                header('Location: login.php?registered=1');
                exit;
            } else {
                $error = "Échec de l'inscription.";
            }
        } catch (Exception $e) {
            $error = "Erreur : " . $e->getMessage();
        }
    }
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8" />
    <title>Inscription Admin - Goshen Tabernacle</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 flex items-center justify-center min-h-screen">
    <div class="bg-white p-8 rounded shadow-md w-full max-w-md">
        <h1 class="text-2xl font-bold mb-6 text-center">🔐 Créer le Compte Admin</h1>
        <?php if (isset($error)): ?>
            <p class="text-red-600 mb-4"><?= htmlspecialchars($error) ?></p>
        <?php endif; ?>
        <?php if (isset($_GET['registered'])): ?>
            <p class="text-green-600 mb-4">✅ Admin créé ! <a href="login.php" class="text-blue-600">Se connecter</a></p>
        <?php endif; ?>

        <form method="POST">
            <div class="mb-4">
                <label>Nom</label>
                <input type="text" name="nom" required class="border p-2 w-full rounded" />
            </div>
            <div class="mb-4">
                <label>Email</label>
                <input type="email" name="email" required class="border p-2 w-full rounded" />
            </div>
            <div class="mb-4">
                <label>Mot de passe</label>
                <input type="password" name="password" required class="border p-2 w-full rounded" />
            </div>
            <div class="mb-6">
                <label>Confirmer</label>
                <input type="password" name="confirm" required class="border p-2 w-full rounded" />
            </div>
            <button type="submit" class="bg-green-600 text-white px-4 py-2 rounded w-full">
                Créer le Compte Admin
            </button>
        </form>
        <p class="mt-4 text-center">
            <a href="login.php" class="text-blue-600">Déjà un compte ? Se connecter</a>
        </p>
    </div>
</body>
</html>