<?php
require_once '../src/config/auth.php';
$auth = new Auth();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = $_POST['email'];
    $password = $_POST['password'];

    if ($auth->login($email, $password)) {
        header('Location: index.php');
        exit;
    } else {
        $error = "Email ou mot de passe incorrect.";
    }
    if ($auth->login($email, $password)) {
    // Force la mise  jour du rle en session
    $user = $auth->user();
    $_SESSION['role'] = $user['role'];

    header('Location: index.php');
    exit;
}
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8" />
    <title>Connexion - Goshen Tabernacle</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 flex items-center justify-center min-h-screen">
    <div class="bg-white p-8 rounded shadow-md w-full max-w-md">
        <h1 class="text-2xl font-bold mb-6 text-center">🔑 Connexion</h1>
        <?php if (isset($error)): ?>
            <p class="text-red-600 mb-4"><?= htmlspecialchars($error) ?></p>
        <?php endif; ?>
        <?php if (isset($_GET['registered'])): ?>
            <p class="text-green-600 mb-4">✅ Inscrit ! Connectez-vous.</p>
        <?php endif; ?>

        <form method="POST">
            <div class="mb-4">
                <label>Email</label>
                <input type="email" name="email" required class="border p-2 w-full rounded" />
            </div>
            <div class="mb-6">
                <label>Mot de passe</label>
                <input type="password" name="password" required class="border p-2 w-full rounded" />
            </div>
            <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded w-full">
                Se Connecter
            </button>
        </form>
        <p class="mt-4 text-center">
            Premier accès ? <a href="register.php" class="text-green-600">Créer un compte admin</a>
        </p>
    </div>
</body>
</html>