<?php


// Activer les erreurs (développement)
ini_set('display_errors', 1);
error_reporting(E_ALL);

// Charger l'authentification
require_once '../src/config/auth.php';
$auth = new Auth();

// Vérifier si l'utilisateur est connecté
if (!$auth->isLoggedIn()) {
    header('Location: login.php');
    exit;
}

$user = $auth->user();


// Connexion à la base
$db = (new Database())->getConnection();

// 🔹 Totaux par type d'offrande
$stmt = $db->prepare("
    SELECT 
        type,
        SUM(montant_cdf) as total_cdf,
        SUM(montant_usd) as total_usd
    FROM offrandes 
    GROUP BY type
");
$stmt->execute();
$offrandes_par_type = $stmt->fetchAll(PDO::FETCH_ASSOC);

// 🔹 Tableau associatif pour un accès facile
$types = [
    'ordinaire'    => ['nom' => 'Offrandes Ordinaires', 'total' => 0],
    'missionnaire' => ['nom' => 'Offrandes Missionnaires', 'total' => 0],
    'parcelle'     => ['nom' => 'Offrandes Achat Parcelle', 'total' => 0],
    'autre'        => ['nom' => 'Autres Offrandes', 'total' => 0]
];

// Remplir les totaux
foreach ($offrandes_par_type as $row) {
    $type = $row['type'];
    if (isset($types[$type])) {
        $types[$type]['total'] = (float)$row['total_cdf'];
    }
}

// 🔹 Autres statistiques
$depenses = $db->query("SELECT SUM(montant_cdf) as total FROM depenses")->fetch(PDO::FETCH_ASSOC);
$dons_complets = $db->query("SELECT SUM(montant_cdf) as total FROM dons WHERE statut = 'complet'")->fetch(PDO::FETCH_ASSOC);
$articles = $db->query("SELECT COUNT(*) as total FROM articles")->fetch(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="fr" manifest="/manifest.appcache">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Goshen Tabernacle</title>
    <link rel="manifest" href="/manifest.json" />
    <link rel="icon" href="/assets/img/icon-192.png" />
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet" />
    <script src="/assets/js/app.js" defer></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <p class="text-sm text-gray-500">Connecté : <strong><?= htmlspecialchars($user['nom']) ?></strong> (<?= $user['role'] ?>)</p>
<a href="logout.php" class="text-red-600 text-sm">Déconnexion</a>
</head>
<body class="bg-gray-100 text-gray-900 font-sans">

    <!-- Sidebar -->
    <div class="fixed inset-y-0 left-0 w-64 bg-gray-900 text-white shadow-lg z-10 transform transition-transform duration-300">
        <div class="p-5">
            <h1 class="text-xl font-bold">Goshen Tabernacle</h1>
            <nav class="mt-8 space-y-2">
                <a href="index.php" class="block px-4 py-2 rounded hover:bg-gray-800">📊 Dashboard</a>
                <a href="encaissement.php" class="block px-4 py-2 rounded hover:bg-gray-800">💰 Encaissement</a>
                <a href="dons-parcelle.php" class="block px-4 py-2 rounded hover:bg-gray-800">🎁 Dons Parcelle</a>
                <a href="depenses.php" class="block px-4 py-2 rounded hover:bg-gray-800">💸 Dépenses</a>
                <a href="patrimoine.php" class="block px-4 py-2 rounded hover:bg-gray-800">🛠️ Patrimoine</a>
                <a href="maintenance.php" class="block px-4 py-2 rounded hover:bg-gray-800">⚙️ Maintenance</a>
                <a href="rapports.php" class="block px-4 py-2 rounded hover:bg-gray-800">📈 Rapports</a>
            </nav>
        </div>
    </div>

    <!-- Contenu Principal -->
    <main class="ml-64 p-6">
        <h2 class="text-2xl font-bold mb-6">Tableau de Bord</h2>
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
    <?php foreach ($types as $key => $data): ?>
        <div class="bg-white p-6 rounded shadow text-center">
            <h3 class="text-gray-600 text-sm font-medium"><?= $data['nom'] ?></h3>
            <p class="text-xl font-bold mt-2">
                <?= number_format($data['total'], 0, ',', ' ') ?> CDF
            </p>
        </div>
    <?php endforeach; ?>
</div>

<!-- Autres indicateurs -->
<div class="grid grid-cols-1 md:grid-cols-3 gap-6">
    <div class="bg-white p-6 rounded shadow text-center">
        <h3 class="text-gray-600">Total Dépenses</h3>
        <p class="text-xl font-bold text-red-600">
            <?= number_format($depenses['total'] ?? 0, 0, ',', ' ') ?> CDF
        </p>
    </div>
    <div class="bg-white p-6 rounded shadow text-center">
        <h3 class="text-gray-600">Dons Parcelle (Complétés)</h3>
        <p class="text-xl font-bold text-green-600">
            <?= number_format($dons_complets['total'] ?? 0, 0, ',', ' ') ?> CDF
        </p>
    </div>
    <div class="bg-white p-6 rounded shadow text-center">
        <h3 class="text-gray-600">Patrimoine</h3>
        <p class="text-xl font-bold">
            <?= $articles['total'] ?? 0 ?> articles
        </p>
    </div>
</div>

        <!-- Graphiques (optionnel - via Chart.js) -->
        
        
        <div class="mt-8 bg-white p-6 rounded shadow">
            <canvas id="chartOffrandes"><!-- Graphique des Offrandes -->
<div class="bg-white p-6 rounded shadow mt-8">
    <h2 class="text-xl font-bold mb-4">📊 Répartition des Offrandes (CDF)</h2>
    <canvas id="chartOffrandes" height="100"></canvas>
</div>

<script>
const ctx = document.getElementById('chartOffrandes').getContext('2d');
const chart = new Chart(ctx, {
    type: 'bar',
    data: {
        labels: [
            'Offrandes Ordinaires',
            'Missionnaires',
            'Achat Parcelle',
            'Autres Offrandes'
        ],
        datasets: [{
            label: 'Montant (CDF)',
            backgroundColor: '#10B981',
            borderColor: '#047857',
            data: [
                <?= $types['ordinaire']['total'] ?? 0 ?>,
                <?= $types['missionnaire']['total'] ?? 0 ?>,
                <?= $types['parcelle']['total'] ?? 0 ?>,
                <?= $types['autre']['total'] ?? 0 ?>
            ],
            borderWidth: 1
        }]
    },
    options: {
        responsive: true,
        scales: {
            y: {
                beginAtZero: true,
                ticks: {
                    callback: function(value) {
                        return value.toLocaleString() + ' CDF';
                    }
                }
            }
        },
        plugins: {
            legend: { display: false }
        }
    }
});
</script></canvas>
        </div>
    </main>

    <!-- Service Worker -->
    <script>
        if ('serviceWorker' in navigator) {
            navigator.serviceWorker.register('/sw.js')
                .then(() => console.log('Service Worker enregistré'))
                .catch(err => console.error('Échec:', err));
        }
    </script>
</body>
</html>