<?php
require_once '../vendor/autoload.php'; // dompdf
require_once '../src/config/db.php';

use Dompdf\Dompdf;
use Dompdf\Options;

$options = new Options();
$options->set('isHtml5ParserEnabled', true);
$dompdf = new Dompdf($options);

$mois = $_GET['mois'] ?? date('m');
$annee = $_GET['annee'] ?? date('Y');

$db = (new Database())->getConnection();

// Récupérer les données (copier depuis rapports.php)
// ... (mêmes requêtes)

$html = '
<h1>Rapport Mensuel - ' . date('F Y', mktime(0, 0, 0, $mois, 1, $annee)) . '</h1>
<p><strong>Église : Goshen Tabernacle</strong></p>
<hr>
<h2>Encaissements</h2>
<ul>
    <li>Offrandes Ordinaires : ' . number_format($rapport['ordinaire'], 0, ',', ' ') . ' CDF</li>
    <li>Offrandes Missionnaires : ' . number_format($rapport['missionnaire'], 0, ',', ' ') . ' CDF</li>
    <li>Offrandes Achat Parcelle : ' . number_format($rapport['parcelle'], 0, ',', ' ') . ' CDF</li>
    <li>Autres Offrandes : ' . number_format($rapport['autre'], 0, ',', ' ') . ' CDF</li>
</ul>
<h2>Dépenses</h2>
<ul>
    <li>Compte Ordinaire : ' . number_format($depenses['ordinaire'], 0, ',', ' ') . ' CDF</li>
    <li>Compte Missionnaire : ' . number_format($depenses['missionnaire'], 0, ',', ' ') . ' CDF</li>
</ul>
<h2>Bilan : ' . number_format($bilan, 0, ',', ' ') . ' CDF</h2>
<p><em>Document généré le ' . date('d/m/Y H:i') . '</em></p>
';

$dompdf->loadHtml($html);
$dompdf->setPaper('A4', 'portrait');
$dompdf->render();
$dompdf->stream("rapport-$mois-$annee.pdf", ["Attachment" => false]);
exit;