<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

require_once '../src/config/auth.php';
$auth = new Auth();

if (!$auth->isLoggedIn()) {
    header('Location: login.php');
    exit;
}

if (!$auth->hasRole(['tresorier', 'admin'])) {
    die("Accès refusé.");
}

$db = (new Database())->getConnection();

$message = '';

// Enregistrer une dépense
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $compte = $_POST['compte'];
    $description = trim($_POST['description']);
    $cdf = floatval($_POST['montant_cdf'] ?? 0);
    $usd = floatval($_POST['montant_usd'] ?? 0);

    $comptes_valides = ['ordinaire', 'missionnaire'];
    if (!in_array($compte, $comptes_valides) || empty($description) || ($cdf <= 0 && $usd <= 0)) {
        $message = "❌ Veuillez remplir tous les champs correctement.";
    } else {
        try {
            $stmt = $db->prepare("INSERT INTO depenses (compte, description, montant_cdf, montant_usd) VALUES (?, ?, ?, ?)");
            $stmt->execute([$compte, $description, $cdf, $usd]);
            $message = "✅ Dépense enregistrée avec succès !";
        } catch (Exception $e) {
            $message = "❌ Erreur : " . $e->getMessage();
        }
    }
}

// Récupérer les dernières dépenses
$stmt = $db->query("SELECT * FROM depenses ORDER BY date_depense DESC LIMIT 20");
$depenses = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8" />
    <title>Dépenses - Goshen Tabernacle</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet" />
</head>
<body class="bg-gray-100 text-gray-900 font-sans">
    <?php include 'partials/sidebar.php'; ?>

    <main class="ml-64 p-6">
        <div class="max-w-4xl mx-auto">
            <h1 class="text-2xl font-bold mb-6">💸 Enregistrement des Dépenses</h1>

            <?php if ($message): ?>
                <div class="p-4 mb-6 rounded 
                    <?= strpos($message, 'Erreur') !== false || strpos($message, 'Veuillez') !== false 
                        ? 'bg-red-100 text-red-800' : 'bg-green-100 text-green-800' ?>">
                    <?= htmlspecialchars($message) ?>
                </div>
            <?php endif; ?>

            <!-- Formulaire -->
            <form method="POST" class="bg-white p-8 rounded shadow mb-8">
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
                    <div>
                        <label class="block mb-2 font-medium">Compte</label>
                        <select name="compte" required class="border p-3 w-full rounded">
                            <option value="">Sélectionner un compte</option>
                            <option value="ordinaire">Offrandes Ordinaires</option>
                            <option value="missionnaire">Offrandes Missionnaires</option>
                        </select>
                    </div>
                    <div>
                        <label class="block mb-2 font-medium">Description</label>
                        <input type="text" name="description" required
                               class="border p-3 w-full rounded" placeholder="Ex: Achat de pastilles" />
                    </div>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
                    <div>
                        <label>Montant en CDF</label>
                        <div class="flex items-center">
                            <span class="bg-gray-200 px-3 py-3 rounded-l border-y border-l border-gray-300">CDF</span>
                            <input type="number" name="montant_cdf" step="0.01" min="0" value="0"
                                   class="border p-3 w-full rounded-r" />
                        </div>
                    </div>
                    <div>
                        <label>Montant en USD</label>
                        <div class="flex items-center">
                            <span class="bg-gray-200 px-3 py-3 rounded-l border-y border-l border-gray-300">$</span>
                            <input type="number" name="montant_usd" step="0.01" min="0" value="0"
                                   class="border p-3 w-full rounded-r" />
                        </div>
                    </div>
                </div>

                <div class="flex gap-4">
                    <button type="submit" class="bg-red-600 hover:bg-red-700 text-white px-6 py-3 rounded font-medium">
                        <i class="fas fa-save mr-2"></i> Enregistrer Dépense
                    </button>
                    <a href="index.php" class="bg-gray-500 hover:bg-gray-600 text-white px-6 py-3 rounded font-medium">
                        <i class="fas fa-arrow-left mr-2"></i> Retour
                    </a>
                </div>
            </form>

            <!-- Historique -->
            <div class="bg-white p-6 rounded shadow">
                <h2 class="text-xl font-bold mb-4">📜 Dernières Dépenses</h2>
                <table class="w-full border-collapse text-sm">
                    <thead class="bg-gray-100">
                        <tr>
                            <th class="border p-2 text-left">Compte</th>
                            <th class="border p-2 text-left">Description</th>
                            <th class="border p-2 text-right">CDF</th>
                            <th class="border p-2 text-right">USD</th>
                            <th class="border p-2 text-right">Date</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($depenses as $d): ?>
                        <tr class="hover:bg-gray-50">
                            <td class="border p-2"><?= ucfirst($d['compte']) ?></td>
                            <td class="border p-2"><?= htmlspecialchars($d['description']) ?></td>
                            <td class="border p-2 text-right"><?= number_format($d['montant_cdf'], 0, ',', ' ') ?></td>
                            <td class="border p-2 text-right"><?= number_format($d['montant_usd'], 2) ?></td>
                            <td class="border p-2 text-right"><?= (new DateTime($d['date_depense']))->format('d/m/Y') ?></td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </main>
</body>
</html>