<?php
// public/api/souscriptions.php
header('Content-Type: application/json');

require_once '../../src/config/db.php';
$db = (new Database())->getConnection();

$appel_id = $_GET['appel_id'] ?? null;

if (!$appel_id || !is_numeric($appel_id)) {
    echo json_encode(['error' => 'ID invalide']);
    exit;
}

$stmt = $db->prepare("
    SELECT 
        s.id, s.nom_membre, s.montant_cdf, s.montant_usd, s.statut,
        COALESCE(SUM(p.montant_cdf), 0) as total_paye_cdf,
        COALESCE(SUM(p.montant_usd), 0) as total_paye_usd,
        a.titre as appel_titre
    FROM souscriptions s
    LEFT JOIN paiements_tranches p ON s.id = p.souscription_id
    LEFT JOIN appels_de_fond a ON s.appel_id = a.id
    WHERE s.appel_id = ?
    GROUP BY s.id
    ORDER BY s.statut, s.date_souscription DESC
");
$stmt->execute([$appel_id]);
$souscriptions = $stmt->fetchAll(PDO::FETCH_ASSOC);

echo json_encode(['souscriptions' => $souscriptions]);