<?php
// public/api/ajouter-souscription.php
header('Content-Type: application/json');

require_once '../../src/config/auth.php';
$auth = new Auth();

if (!$auth->isLoggedIn()) {
    http_response_code(401);
    echo json_encode(['error' => 'Non connecté']);
    exit;
}

$db = (new Database())->getConnection();

$data = json_decode(file_get_contents('php://input'), true);
$nom = trim($data['nom_membre'] ?? '');
$montant_cdf = floatval($data['montant_cdf'] ?? 0);
$montant_usd = floatval($data['montant_usd'] ?? 0);
$appel_id = intval($data['appel_id'] ?? 0);

if (!$nom || ($montant_cdf <= 0 && $montant_usd <= 0) || $appel_id <= 0) {
    http_response_code(400);
    echo json_encode(['error' => 'Données invalides']);
    exit;
}

try {
    $stmt = $db->prepare("INSERT INTO souscriptions (nom_membre, montant_cdf, montant_usd, appel_id) VALUES (?, ?, ?, ?)");
    $stmt->execute([$nom, $montant_cdf, $montant_usd, $appel_id]);

    $nouveau_id = $db->lastInsertId();

    // Récupérer le titre de l'appel
    $appel = $db->prepare("SELECT titre FROM appels_de_fond WHERE id = ?");
    $appel->execute([$appel_id]);
    $appel_titre = $appel->fetchColumn() ?: 'Inconnu';

    echo json_encode([
        'success' => true,
        'message' => "Souscription ajoutée pour $nom",
        'souscription' => [
            'id' => $nouveau_id,
            'nom_membre' => $nom,
            'montant_cdf' => $montant_cdf,
            'montant_usd' => $montant_usd,
            'reste_cdf' => $montant_cdf,
            'reste_usd' => $montant_usd,
            'statut' => 'actif',
            'appel_titre' => $appel_titre
        ]
    ]);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Erreur base de données : ' . $e->getMessage()]);
}