<?php
 namespace MailPoetVendor\Symfony\Component\Validator\Constraints; if (!defined('ABSPATH')) exit; use MailPoetVendor\Symfony\Component\Validator\Constraint; use MailPoetVendor\Symfony\Component\Validator\ConstraintValidator; use MailPoetVendor\Symfony\Component\Validator\Exception\UnexpectedTypeException; use MailPoetVendor\Symfony\Component\Validator\Exception\UnexpectedValueException; class CollectionValidator extends ConstraintValidator { public function validate($value, Constraint $constraint) { if (!$constraint instanceof Collection) { throw new UnexpectedTypeException($constraint, Collection::class); } if (null === $value) { return; } if (!\is_array($value) && !($value instanceof \Traversable && $value instanceof \ArrayAccess)) { throw new UnexpectedValueException($value, 'array|(Traversable&ArrayAccess)'); } $context = $this->context; foreach ($constraint->fields as $field => $fieldConstraint) { $existsInArray = \is_array($value) && \array_key_exists($field, $value); $existsInArrayAccess = $value instanceof \ArrayAccess && $value->offsetExists($field); if ($existsInArray || $existsInArrayAccess) { if (\count($fieldConstraint->constraints) > 0) { $context->getValidator()->inContext($context)->atPath('[' . $field . ']')->validate($value[$field], $fieldConstraint->constraints); } } elseif (!$fieldConstraint instanceof Optional && !$constraint->allowMissingFields) { $context->buildViolation($constraint->missingFieldsMessage)->atPath('[' . $field . ']')->setParameter('{{ field }}', $this->formatValue($field))->setInvalidValue(null)->setCode(Collection::MISSING_FIELD_ERROR)->addViolation(); } } if (!$constraint->allowExtraFields) { foreach ($value as $field => $fieldValue) { if (!isset($constraint->fields[$field])) { $context->buildViolation($constraint->extraFieldsMessage)->atPath('[' . $field . ']')->setParameter('{{ field }}', $this->formatValue($field))->setInvalidValue($fieldValue)->setCode(Collection::NO_SUCH_FIELD_ERROR)->addViolation(); } } } } } 